/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block.tileentity;

import doggytalents.DoggyTileEntityTypes;
import doggytalents.api.feature.FoodHandler;
import doggytalents.common.block.tileentity.PlacedTileEntity;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.inventory.container.FoodBowlContainer;
import doggytalents.common.util.DogFoodUtil;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemStackHandler;

public class FoodBowlTileEntity
extends PlacedTileEntity
implements MenuProvider {
    private final ItemStackHandler inventory = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            FoodBowlTileEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return FoodHandler.isFood(stack).isPresent();
        }
    };
    public int timeoutCounter;

    public FoodBowlTileEntity(BlockPos pos, BlockState blockState) {
        super(DoggyTileEntityTypes.FOOD_BOWL.get(), pos, blockState);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound);
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128391_(this.inventory.serializeNBT());
    }

    public static void tick(Level level, BlockPos pos, BlockState blockState, BlockEntity blockEntity) {
        if (level == null) {
            return;
        }
        if (level.f_46443_) {
            return;
        }
        if (!(blockEntity instanceof FoodBowlTileEntity)) {
            return;
        }
        FoodBowlTileEntity bowl = (FoodBowlTileEntity)blockEntity;
        if (++bowl.timeoutCounter < 20) {
            return;
        }
        List dogList = level.m_45976_(Dog.class, new AABB(pos).m_82377_(5.0, 5.0, 5.0));
        for (Dog dog : dogList) {
            if (!dog.isDoingFine()) continue;
            UUID placerId = bowl.getPlacerId();
            if (placerId != null && !dog.getBowlPos().isPresent() && placerId.equals(dog.m_21805_())) {
                dog.setBowlPos(bowl.m_58899_());
            }
            if (!bowl.shouldFeed(dog)) continue;
            dog.triggerAction(new DogEatFromFoodBowl(dog, bowl));
        }
        bowl.timeoutCounter = 0;
    }

    private boolean shouldFeed(Dog target) {
        if (target.isBusy()) {
            return false;
        }
        if (target.m_21825_()) {
            return false;
        }
        if (target.m_21827_()) {
            return false;
        }
        if (!this.hasFood(target)) {
            return false;
        }
        return this.isHungryDog(target);
    }

    private boolean isHungryDog(Dog dog) {
        return dog.isDoingFine() && dog.getDogHunger() < 25.0f;
    }

    public boolean hasFood(Dog dog) {
        return DogFoodUtil.dogFindFoodInInv(dog, false, this.getInventory()) >= 0;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.doggytalents.food_bowl");
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerIn) {
        return new FoodBowlContainer(windowId, this.f_58857_, this.f_58858_, playerInventory, playerIn);
    }

    public static class DogEatFromFoodBowl
    extends TriggerableAction {
        private final FoodBowlTileEntity bowl;
        private int tickTillPathRecalc;
        private boolean enoughHealingFood = false;
        private int goToBowlTimeout = 0;
        private int feedCooldown = 0;
        private boolean failedEating = false;

        public DogEatFromFoodBowl(Dog dog, FoodBowlTileEntity bowl) {
            super(dog, false, false);
            this.bowl = bowl;
        }

        @Override
        public void onStart() {
            this.goToBowlTimeout = 200;
        }

        @Override
        public void tick() {
            boolean is_close_to_bowl;
            if (!this.stillValidTarget()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.enoughEating()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.failedEating) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            boolean bl = is_close_to_bowl = this.getBowlDistanceSqr() <= 2.25;
            if (!is_close_to_bowl) {
                --this.goToBowlTimeout;
            }
            if (this.goToBowlTimeout <= 0 && !is_close_to_bowl) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.feedCooldown > 0) {
                --this.feedCooldown;
            }
            if (!is_close_to_bowl) {
                Vec3 bowlPos = this.getBowPos();
                this.dog.m_21563_().m_24950_(bowlPos.f_82479_, bowlPos.f_82480_, bowlPos.f_82481_, 10.0f, (float)this.dog.m_8132_());
                if (--this.tickTillPathRecalc <= 0) {
                    this.tickTillPathRecalc = 10;
                    if (!this.dog.m_21523_() && !this.dog.m_20159_()) {
                        this.dog.m_21573_().m_26519_(bowlPos.f_82479_, bowlPos.f_82480_, bowlPos.f_82481_, (double)this.dog.getUrgentSpeedModifier());
                    }
                }
            } else {
                this.dog.m_21573_().m_26573_();
                this.checkAndEat();
            }
        }

        @Override
        public void onStop() {
        }

        private boolean enoughEating() {
            float hunger = this.dog.getDogHunger();
            if (hunger < 80.0f) {
                return false;
            }
            return !this.dog.isDogLowHealth() || !(hunger < this.dog.getMaxHunger());
        }

        private void checkAndEat() {
            boolean dogNeedsHealing;
            if (this.feedCooldown > 0) {
                return;
            }
            boolean bl = dogNeedsHealing = this.dog.isDogLowHealth() && !this.dog.m_21023_(MobEffects.f_19605_);
            if (!this.enoughHealingFood && dogNeedsHealing) {
                this.enoughHealingFood = true;
                this.failedEating = !DogFoodUtil.tryFeed(this.dog, true, this.bowl.getInventory());
            } else {
                this.failedEating = !DogFoodUtil.tryFeed(this.dog, false, this.bowl.getInventory());
            }
            this.feedCooldown = this.dog.m_217043_().m_188503_(11);
        }

        private boolean stillValidTarget() {
            if (this.bowl.m_58901_()) {
                return false;
            }
            if (this.getBowlDistanceSqr() > 256.0) {
                return false;
            }
            return this.bowl.hasFood(this.dog);
        }

        private double getBowlDistanceSqr() {
            Vec3 bowlPos = this.getBowPos();
            return this.dog.m_20238_(bowlPos);
        }

        private Vec3 getBowPos() {
            return Vec3.m_82539_((Vec3i)this.bowl.m_58899_());
        }
    }
}

